/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Web.UI.WebControls;
using Borland.Eco.ObjectRepresentation;

namespace Borland.Eco.Web
{
	/// <summary>
	/// Summary description for CheckBoxAsBooleanBinding.
	/// </summary>
	public class CheckBoxAsBooleanBinding: EcoPropertyBinding
	{
		private CheckBox checkBox;
		private CheckBox checkBoxNull;
		private IProperty property;
		private string name;

		public CheckBoxAsBooleanBinding(CheckBox cbx, CheckBox cbxNull, IProperty prop): base()
		{
			checkBox = cbx;
			checkBoxNull = cbxNull;
			property = prop;
		}

		public CheckBoxAsBooleanBinding(CheckBox cbx, CheckBox cbxNull, string name): base()
		{
			checkBox = cbx;
			checkBoxNull = cbxNull;
			this.name = name;
		}

		public override void Apply()
		{
			if (checkBoxNull != null && checkBoxNull.Checked)
			{
				property.AsObject = null;			
			}
			else 
			{
				property.AsObject = checkBox.Checked;			
			}
		}


		public override void Refresh()
		{
			if (checkBoxNull != null && property.AsObject == null) 
			{
				checkBoxNull.Checked = true;				
				checkBox.Checked = false;								
			}
			else 
			{
				checkBoxNull.Checked = false;				
				checkBox.Checked = (bool) property.AsObject;								
			}
		}


		public override string AppendToFilter()
		{
			string filter = "";
			if (checkBox.Checked)
			{
				filter = "->select(" + name + ")"; // do not localize
			}
			/*
			Need a way to specify search for false
			else
			{
				filter = "->reject(" + name + ")"; // do not localize				
			}
			*/
			return filter;
		}

	}
}
